<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * The payment card to use to fund a payment. Can be a credit or debit card.<blockquote><strong>Note:
 * </strong> Passing card number, cvv and expiry directly via the API requires <a href="https://www.
 * pcisecuritystandards.org/pci_security/completing_self_assessment"> PCI SAQ D compliance</a>.
 * <br>*PayPal offers a mechanism by which you do not have to take on the <strong>PCI SAQ D</strong>
 * burden by using hosted fields - refer to <a href="https://developer.paypal.
 * com/docs/checkout/advanced/integrate/">this Integration Guide</a>*.</blockquote>
 */
class CardRequest implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $name;

    /**
     * @var string|null
     */
    private $number;

    /**
     * @var string|null
     */
    private $expiry;

    /**
     * @var string|null
     */
    private $securityCode;

    /**
     * @var Address|null
     */
    private $billingAddress;

    /**
     * @var CardAttributes|null
     */
    private $attributes;

    /**
     * @var string|null
     */
    private $vaultId;

    /**
     * @var string|null
     */
    private $singleUseToken;

    /**
     * @var CardStoredCredential|null
     */
    private $storedCredential;

    /**
     * @var NetworkToken|null
     */
    private $networkToken;

    /**
     * @var CardExperienceContext|null
     */
    private $experienceContext;

    /**
     * Returns Name.
     * The card holder's name as it appears on the card.
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * Sets Name.
     * The card holder's name as it appears on the card.
     *
     * @maps name
     */
    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns Number.
     * The primary account number (PAN) for the payment card.
     */
    public function getNumber(): ?string
    {
        return $this->number;
    }

    /**
     * Sets Number.
     * The primary account number (PAN) for the payment card.
     *
     * @maps number
     */
    public function setNumber(?string $number): void
    {
        $this->number = $number;
    }

    /**
     * Returns Expiry.
     * The year and month, in ISO-8601 `YYYY-MM` date format. See [Internet date and time format](https:
     * //tools.ietf.org/html/rfc3339#section-5.6).
     */
    public function getExpiry(): ?string
    {
        return $this->expiry;
    }

    /**
     * Sets Expiry.
     * The year and month, in ISO-8601 `YYYY-MM` date format. See [Internet date and time format](https:
     * //tools.ietf.org/html/rfc3339#section-5.6).
     *
     * @maps expiry
     */
    public function setExpiry(?string $expiry): void
    {
        $this->expiry = $expiry;
    }

    /**
     * Returns Security Code.
     * The three- or four-digit security code of the card. Also known as the CVV, CVC, CVN, CVE, or CID.
     * This parameter cannot be present in the request when `payment_initiator=MERCHANT`.
     */
    public function getSecurityCode(): ?string
    {
        return $this->securityCode;
    }

    /**
     * Sets Security Code.
     * The three- or four-digit security code of the card. Also known as the CVV, CVC, CVN, CVE, or CID.
     * This parameter cannot be present in the request when `payment_initiator=MERCHANT`.
     *
     * @maps security_code
     */
    public function setSecurityCode(?string $securityCode): void
    {
        $this->securityCode = $securityCode;
    }

    /**
     * Returns Billing Address.
     * The portable international postal address. Maps to [AddressValidationMetadata](https://github.
     * com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form
     * controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-
     * controls-the-autocomplete-attribute).
     */
    public function getBillingAddress(): ?Address
    {
        return $this->billingAddress;
    }

    /**
     * Sets Billing Address.
     * The portable international postal address. Maps to [AddressValidationMetadata](https://github.
     * com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form
     * controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-
     * controls-the-autocomplete-attribute).
     *
     * @maps billing_address
     */
    public function setBillingAddress(?Address $billingAddress): void
    {
        $this->billingAddress = $billingAddress;
    }

    /**
     * Returns Attributes.
     * Additional attributes associated with the use of this card.
     */
    public function getAttributes(): ?CardAttributes
    {
        return $this->attributes;
    }

    /**
     * Sets Attributes.
     * Additional attributes associated with the use of this card.
     *
     * @maps attributes
     */
    public function setAttributes(?CardAttributes $attributes): void
    {
        $this->attributes = $attributes;
    }

    /**
     * Returns Vault Id.
     * The PayPal-generated ID for the vaulted payment source. This ID should be stored on the merchant's
     * server so the saved payment source can be used for future transactions.
     */
    public function getVaultId(): ?string
    {
        return $this->vaultId;
    }

    /**
     * Sets Vault Id.
     * The PayPal-generated ID for the vaulted payment source. This ID should be stored on the merchant's
     * server so the saved payment source can be used for future transactions.
     *
     * @maps vault_id
     */
    public function setVaultId(?string $vaultId): void
    {
        $this->vaultId = $vaultId;
    }

    /**
     * Returns Single Use Token.
     * The PayPal-generated, short-lived, one-time-use token, used to communicate payment information to
     * PayPal for transaction processing.
     */
    public function getSingleUseToken(): ?string
    {
        return $this->singleUseToken;
    }

    /**
     * Sets Single Use Token.
     * The PayPal-generated, short-lived, one-time-use token, used to communicate payment information to
     * PayPal for transaction processing.
     *
     * @maps single_use_token
     */
    public function setSingleUseToken(?string $singleUseToken): void
    {
        $this->singleUseToken = $singleUseToken;
    }

    /**
     * Returns Stored Credential.
     * Provides additional details to process a payment using a `card` that has been stored or is intended
     * to be stored (also referred to as stored_credential or card-on-file).<br/>Parameter compatibility:
     * <br/><ul><li>`payment_type=ONE_TIME` is compatible only with `payment_initiator=CUSTOMER`.
     * </li><li>`usage=FIRST` is compatible only with `payment_initiator=CUSTOMER`.
     * </li><li>`previous_transaction_reference` or `previous_network_transaction_reference` is compatible
     * only with `payment_initiator=MERCHANT`.</li><li>Only one of the parameters -
     * `previous_transaction_reference` and `previous_network_transaction_reference` - can be present in
     * the request.</li></ul>
     */
    public function getStoredCredential(): ?CardStoredCredential
    {
        return $this->storedCredential;
    }

    /**
     * Sets Stored Credential.
     * Provides additional details to process a payment using a `card` that has been stored or is intended
     * to be stored (also referred to as stored_credential or card-on-file).<br/>Parameter compatibility:
     * <br/><ul><li>`payment_type=ONE_TIME` is compatible only with `payment_initiator=CUSTOMER`.
     * </li><li>`usage=FIRST` is compatible only with `payment_initiator=CUSTOMER`.
     * </li><li>`previous_transaction_reference` or `previous_network_transaction_reference` is compatible
     * only with `payment_initiator=MERCHANT`.</li><li>Only one of the parameters -
     * `previous_transaction_reference` and `previous_network_transaction_reference` - can be present in
     * the request.</li></ul>
     *
     * @maps stored_credential
     */
    public function setStoredCredential(?CardStoredCredential $storedCredential): void
    {
        $this->storedCredential = $storedCredential;
    }

    /**
     * Returns Network Token.
     * The Third Party Network token used to fund a payment.
     */
    public function getNetworkToken(): ?NetworkToken
    {
        return $this->networkToken;
    }

    /**
     * Sets Network Token.
     * The Third Party Network token used to fund a payment.
     *
     * @maps network_token
     */
    public function setNetworkToken(?NetworkToken $networkToken): void
    {
        $this->networkToken = $networkToken;
    }

    /**
     * Returns Experience Context.
     * Customizes the payer experience during the 3DS Approval for payment.
     */
    public function getExperienceContext(): ?CardExperienceContext
    {
        return $this->experienceContext;
    }

    /**
     * Sets Experience Context.
     * Customizes the payer experience during the 3DS Approval for payment.
     *
     * @maps experience_context
     */
    public function setExperienceContext(?CardExperienceContext $experienceContext): void
    {
        $this->experienceContext = $experienceContext;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->name)) {
            $json['name']               = $this->name;
        }
        if (isset($this->number)) {
            $json['number']             = $this->number;
        }
        if (isset($this->expiry)) {
            $json['expiry']             = $this->expiry;
        }
        if (isset($this->securityCode)) {
            $json['security_code']      = $this->securityCode;
        }
        if (isset($this->billingAddress)) {
            $json['billing_address']    = $this->billingAddress;
        }
        if (isset($this->attributes)) {
            $json['attributes']         = $this->attributes;
        }
        if (isset($this->vaultId)) {
            $json['vault_id']           = $this->vaultId;
        }
        if (isset($this->singleUseToken)) {
            $json['single_use_token']   = $this->singleUseToken;
        }
        if (isset($this->storedCredential)) {
            $json['stored_credential']  = $this->storedCredential;
        }
        if (isset($this->networkToken)) {
            $json['network_token']      = $this->networkToken;
        }
        if (isset($this->experienceContext)) {
            $json['experience_context'] = $this->experienceContext;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
