<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\ShippingName;
use PaypalServerSdkLib\Models\VaultedDigitalWalletShippingDetails;

/**
 * Builder for model VaultedDigitalWalletShippingDetails
 *
 * @see VaultedDigitalWalletShippingDetails
 */
class VaultedDigitalWalletShippingDetailsBuilder
{
    /**
     * @var VaultedDigitalWalletShippingDetails
     */
    private $instance;

    private function __construct(VaultedDigitalWalletShippingDetails $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new vaulted digital wallet shipping details Builder object.
     */
    public static function init(): self
    {
        return new self(new VaultedDigitalWalletShippingDetails());
    }

    /**
     * Sets name field.
     */
    public function name(?ShippingName $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets type field.
     */
    public function type(?string $value): self
    {
        $this->instance->setType($value);
        return $this;
    }

    /**
     * Sets address field.
     */
    public function address(?Address $value): self
    {
        $this->instance->setAddress($value);
        return $this;
    }

    /**
     * Initializes a new vaulted digital wallet shipping details object.
     */
    public function build(): VaultedDigitalWalletShippingDetails
    {
        return CoreHelper::clone($this->instance);
    }
}
