<?php //c03de4aca75e8bd5b263ed1fce7f529e
/** @noinspection all */

namespace App\Events {

    use App\Models\ChatBox;
    use App\Models\User;
    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch($user, $message, $data)
     * @method static PendingBroadcast broadcast($user, $message, $data)
     */
    class MessageReceived {}
    
    /**
     * @method static void dispatch(User $user, ChatBox $message)
     * @method static PendingBroadcast broadcast(User $user, ChatBox $message)
     */
    class MessageSent {}
}

namespace App\Jobs {

    use App\Library\Contracts\CampaignInterface;
    use App\Models\Campaigns;
    use App\Models\Contacts;
    use App\Models\CsvData;
    use Illuminate\Foundation\Bus\PendingDispatch;
    
    /**
     * @method static PendingDispatch dispatch($wait, $campaign, $rateTrackers)
     * @method static mixed dispatchSync($wait, $campaign, $rateTrackers)
     */
    class Delay {}
    
    /**
     * @method static PendingDispatch dispatch(Campaigns $campaign, CsvData $csvData, $db_fields, $plan_id)
     * @method static mixed dispatchSync(Campaigns $campaign, CsvData $csvData, $db_fields, $plan_id)
     */
    class ImportCampaign {}
    
    /**
     * @method static PendingDispatch dispatch(CampaignInterface $campaign, int $page, array $listOfIds)
     * @method static mixed dispatchSync(CampaignInterface $campaign, int $page, array $listOfIds)
     */
    class LoadCampaign {}
    
    /**
     * @method static PendingDispatch dispatch(CampaignInterface $campaign)
     * @method static mixed dispatchSync(CampaignInterface $campaign)
     */
    class RunCampaign {}
    
    /**
     * @method static PendingDispatch dispatch($automation, $contact, $server, $user, $priceOption)
     * @method static mixed dispatchSync($automation, $contact, $server, $user, $priceOption)
     */
    class SendAutomationMessage {}
    
    /**
     * @method static PendingDispatch dispatch($campaign, $sendData, $triggerId = null)
     * @method static mixed dispatchSync($campaign, $sendData, $triggerId = null)
     */
    class SendFileMessage {}
    
    /**
     * @method static PendingDispatch dispatch($campaign, Contacts $contact, $server, $priceOption, $triggerId = null)
     * @method static mixed dispatchSync($campaign, Contacts $contact, $server, $priceOption, $triggerId = null)
     */
    class SendMessage {}
}

namespace Illuminate\Broadcasting {
    
    /**
     * @method static void dispatch(array|Channel|string $channels)
     * @method static PendingBroadcast broadcast(array|Channel|string $channels)
     */
    class AnonymousEvent {}
}

namespace Illuminate\Bus {

    use Illuminate\Foundation\Bus\PendingDispatch;
    
    /**
     * @method static PendingDispatch dispatch(PendingBatch $batch)
     * @method static mixed dispatchSync(PendingBatch $batch)
     */
    class ChainedBatch {}
}

namespace Illuminate\Foundation\Console {

    use Illuminate\Foundation\Bus\PendingDispatch;
    
    /**
     * @method static PendingDispatch dispatch(array $data)
     * @method static mixed dispatchSync(array $data)
     */
    class QueuedCommand {}
}

namespace Illuminate\Foundation\Events {

    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch(array $stubs)
     * @method static PendingBroadcast broadcast(array $stubs)
     */
    class PublishingStubs {}
}

namespace Illuminate\Queue {

    use Illuminate\Foundation\Bus\PendingDispatch;
    use Laravel\SerializableClosure\SerializableClosure;
    
    /**
     * @method static PendingDispatch dispatch(SerializableClosure $closure)
     * @method static mixed dispatchSync(SerializableClosure $closure)
     */
    class CallQueuedClosure {}
}

namespace Maatwebsite\Excel\Jobs {

    use Illuminate\Contracts\Queue\ShouldQueue;
    use Illuminate\Foundation\Bus\PendingDispatch;
    use Maatwebsite\Excel\Concerns\FromQuery;
    use Maatwebsite\Excel\Concerns\FromView;
    use Maatwebsite\Excel\Files\TemporaryFile;
    
    /**
     * @method static PendingDispatch dispatch(object $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex, array $data)
     * @method static mixed dispatchSync(object $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex, array $data)
     */
    class AppendDataToSheet {}
    
    /**
     * @method static PendingDispatch dispatch(FromQuery $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex, int $page, int $perPage)
     * @method static mixed dispatchSync(FromQuery $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex, int $page, int $perPage)
     */
    class AppendPaginatedToSheet {}
    
    /**
     * @method static PendingDispatch dispatch(FromQuery $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex, int $page, int $chunkSize)
     * @method static mixed dispatchSync(FromQuery $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex, int $page, int $chunkSize)
     */
    class AppendQueryToSheet {}
    
    /**
     * @method static PendingDispatch dispatch(FromView $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex)
     * @method static mixed dispatchSync(FromView $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex)
     */
    class AppendViewToSheet {}
    
    /**
     * @method static PendingDispatch dispatch(object $export, TemporaryFile $temporaryFile, string $writerType)
     * @method static mixed dispatchSync(object $export, TemporaryFile $temporaryFile, string $writerType)
     */
    class QueueExport {}
    
    /**
     * @method static PendingDispatch dispatch(ShouldQueue|null $import = null)
     * @method static mixed dispatchSync(ShouldQueue|null $import = null)
     */
    class QueueImport {}
}
