@extends('layouts/contentLayoutMaster')

@section('title', __('locale.menu.Plugins'))

@section('page-style')
    <link rel="stylesheet" href="{{ asset(mix('css/base/pages/app-ecommerce.css')) }}">
    <link rel="stylesheet" href="{{ asset(mix('vendors/css/extensions/sweetalert2.min.css')) }}">
@endsection

@section('content')
    <!-- Wishlist Starts -->
    <section id="wishlist" class="grid-view wishlist-items">
        @foreach($plugins as $plugin)
            <div class="card ecommerce-card">
                <div class="item-img text-center">
                    <img src="{{ $plugin->getIconUrl() ?: asset('images/backgrounds/plugin.svg') }}"
                         class="img-fluid p-5" alt="{{ $plugin->title }}" />

                </div>
                <div class="card-body">
                    <div class="item-wrapper d-flex justify-content-between align-items-center">
                    <span class="badge bg-{{ $plugin->status === 'active' ? 'success' : 'danger' }}">
                        {{ trans('locale.labels.' . $plugin->status) }}
                    </span>
                        <div class="item-cost">
                            <h6 class="item-price">v.{{ $plugin->version }}</h6>
                        </div>
                    </div>
                    <div class="item-name">
                        <a href="javascript:void(0);">
                            {{ $plugin->title }}
                        </a>
                    </div>
                    <p class="card-text item-description">{{ $plugin->description }}</p>
                </div>
                <div class="item-options text-center">
                    @if($plugin->status === 'active')
                        <button type="button" class="btn btn-warning btn-sm btn-wishlist plugin-action"
                                data-url="{{ route('admin.plugins.action', [$plugin->uid, 'disable']) }}"
                                data-method="POST"
                                data-title="{{ __('locale.plugins.disable_plugin') }}"
                                data-text="{{ __('locale.plugins.disable_plugin_description') }}">
                            <i data-feather="x"></i> {{ __('locale.labels.disable') }}
                        </button>
                    @else
                        <button type="button" class="btn btn-primary btn-sm btn-wishlist plugin-action"
                                data-url="{{ route('admin.plugins.action', [$plugin->uid, 'enable']) }}"
                                data-method="POST"
                                data-title="{{ __('locale.plugins.enable_plugin') }}"
                                data-text="{{ __('locale.plugins.enable_plugin_description') }}">
                            <i data-feather="check"></i> {{ __('locale.labels.enable') }}
                        </button>
                    @endif

                    <button type="button" class="btn btn-danger btn-sm btn-wishlist plugin-action"
                            data-url="{{ route('admin.plugins.action', [$plugin->uid, 'uninstall']) }}"
                            data-method="POST"
                            data-title="{{ __('locale.plugins.uninstall_plugin') }}"
                            data-text="{{ __('locale.plugins.uninstall_plugin_description') }}">
                        <i data-feather="trash-2"></i> {{ __('locale.labels.uninstall') }}
                    </button>
                </div>
            </div>
        @endforeach
    </section>
    <!-- Wishlist Ends -->
@endsection



@section('vendor-script')
    {{-- vendor files --}}
    <script src="{{ asset(mix('vendors/js/extensions/sweetalert2.all.min.js')) }}"></script>
@endsection

@section('page-script')

    <script>
      $(document).ready(function() {
        $(".plugin-action").on("click", function() {
          let button = $(this);
          let url = button.data("url");
          let title = button.data("title");
          let text = button.data("text");

          Swal.fire({
            title: title,
            text: text,
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "{{ __('locale.labels.yes') }}, {{ __('locale.buttons.proceed') }}",
            cancelButtonText: "{{ __('locale.buttons.cancel') }}",
            customClass: {
              confirmButton: "btn btn-primary",
              cancelButton: "btn btn-outline-secondary ms-1"
            },
            buttonsStyling: false
          }).then((result) => {
            if (result.value) {
              let form = $("<form>", {
                method: "POST",
                action: url
              });

              let token = $("<input>", {
                type: "hidden",
                name: "_token",
                value: '{{ csrf_token() }}'
              });

              form.append(token);

              $("body").append(form);
              form.submit();
            }
          });
        });
      });
    </script>
@endsection
