<?php

    use Illuminate\Database\Migrations\Migration;
    use Illuminate\Database\Schema\Blueprint;
    use Illuminate\Support\Facades\Schema;

    return new class extends Migration {

        public function up(): void
        {
            Schema::create('support_ticket_notifications', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('ticket_id');
                $table->unsignedBigInteger('user_id');
                $table->string('type'); // e.g. email, web, sms
                $table->string('subject')->nullable();
                $table->text('message')->nullable();
                $table->boolean('is_read')->default(false);
                $table->timestamps();

                $table->foreign('ticket_id')->references('id')->on('support_tickets')->onDelete('cascade');
            });
        }

        public function down(): void
        {
            Schema::dropIfExists('support_ticket_notifications');
        }

    };
