<?php

    use Illuminate\Database\Migrations\Migration;
    use Illuminate\Database\Schema\Blueprint;
    use Illuminate\Support\Facades\Schema;

    return new class extends Migration {
        public function up(): void
        {
            Schema::create('support_ticket_attachments', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('message_id');
                $table->string('filename');
                $table->string('filepath');
                $table->string('mime_type')->nullable();
                $table->unsignedBigInteger('uploaded_by');
                $table->timestamps();

                $table->foreign('message_id')->references('id')->on('support_ticket_messages')->onDelete('cascade');
                $table->foreign('uploaded_by')->references('id')->on('users');
            });
        }

        public function down(): void
        {
            Schema::dropIfExists('support_ticket_attachments');
        }

    };
