<?php

    use Illuminate\Database\Migrations\Migration;
    use Illuminate\Database\Schema\Blueprint;
    use Illuminate\Support\Facades\Schema;

    class CreateSupportArticlesTable extends Migration
    {
        public function up(): void
        {
            Schema::create('support_articles', function (Blueprint $table) {
                $table->id();
                $table->uuid()->unique();
                $table->string('title');
                $table->string('slug')->unique();
                $table->longText('content');
                $table->unsignedBigInteger('category_id')->nullable();
                $table->unsignedBigInteger('created_by')->nullable(); // Admin/agent who wrote the article
                $table->boolean('is_published')->default(false);
                $table->integer('views')->default(0);
                $table->timestamps();

                $table->foreign('category_id')->references('id')->on('support_categories')->onDelete('set null');
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            });
        }

        public function down(): void
        {
            Schema::dropIfExists('support_articles');
        }

    }
