<?php

    use Illuminate\Database\Migrations\Migration;
    use Illuminate\Database\Schema\Blueprint;
    use Illuminate\Support\Facades\Schema;

    class CreateSupportCategoriesTable extends Migration
    {
        public function up(): void
        {
            Schema::create('support_categories', function (Blueprint $table) {
                $table->id();
                $table->uuid()->unique();
                $table->string('name')->unique(); // Category name
                $table->string('slug')->unique(); // For URL or API use
                $table->text('description')->nullable(); // Optional description
                $table->boolean('is_active')->default(true);
                $table->unsignedBigInteger('created_by')->nullable(); // Admin/agent who created it
                $table->timestamps();

                // Optional foreign key if users table tracks admin/agents
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            });
        }

        public function down(): void
        {
            Schema::dropIfExists('support_categories');
        }

    }
